//
//  ViewController.swift
//  Winzo
//
//  Created by Mishal Udeshi on 21/08/23.
//

import UIKit
import WebKit

class ViewController: UIViewController {

    var webView: WKWebView!
    var activityIndicator: UIActivityIndicatorView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        // Create a WKWebView instance
       
        let statusBarHeight = UIApplication.shared.statusBarFrame.height
                // Initialize the frame
              
                // Set background color of status bar (optional)
                self.view.backgroundColor = UIColor(red: 248/255.0, green: 248/255.0, blue: 248/255.0, alpha: 1.0)
        webView = WKWebView(frame: CGRect.init(x: 0, y: statusBarHeight, width: view.bounds.maxX, height: view.bounds.maxY),configuration: WKWebViewConfiguration())
        
               webView.navigationDelegate = self
        view.addSubview(webView)
        
        activityIndicator = UIActivityIndicatorView(style: .large)
        activityIndicator.center = view.center
        activityIndicator.hidesWhenStopped = true
        view.addSubview(activityIndicator)

           // Add the web view to the view hierarchy
           
           // Load a URL
           if let url = URL(string: "https://www.winbuzz.in") {
               let request = URLRequest(url: url)
               webView.load(request)
           }
//        navigationController?.isToolbarHidden = false
        
       
          
    }
    

    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        //navigationController?.navigationItem.title = "Winbuzz"
    navigationController?.isNavigationBarHidden = true
    }

}

extension ViewController: WKNavigationDelegate {
    func webView(_ webView: WKWebView, didStartProvisionalNavigation navigation: WKNavigation!) {
        activityIndicator.startAnimating()
    }
    
    func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        activityIndicator.stopAnimating()
    }
    
    func webView(_ webView: WKWebView, didFail navigation: WKNavigation!, withError error: Error) {
        activityIndicator.stopAnimating()
    }
}
